#!/bin/python
# Tests for variable substitutions
# A. Schlemmer, 05/2022

from caoscrawler import Crawler
from caoscrawler.structure_elements import File, DictTextElement, DictListElement
from caoscrawler.identifiable_adapters import IdentifiableAdapter, LocalStorageIdentifiableAdapter
from functools import partial
from copy import deepcopy
from unittest.mock import MagicMock, Mock
from os.path import join, dirname, basename
import yaml
import caosdb as db
from caosdb.apiutils import compare_entities

import pytest
from pytest import raises


def rfp(*pathcomponents):
    """
    Return full path.
    Shorthand convenience function.
    """
    return join(dirname(__file__), *pathcomponents)


def dircheckstr(element_type, *pathcomponents):
    """
    Return the debug tree identifier for a given path.
    """
    return "caoscrawler.structure_elements." + element_type + ": " + basename(join(*pathcomponents)) + ", " + rfp("test_directories", "example_substitutions", *pathcomponents)


@pytest.fixture
def crawler():
    crawler = Crawler(debug=True)
    crawler.crawl_directory(rfp("test_directories", "example_substitutions", "ExperimentalData"),
                            rfp("test_directories", "example_substitutions", "substitutions.yml"))
    return crawler


@pytest.fixture
def crawler_2():
    crawler = Crawler(debug=True)
    crawler.crawl_directory(rfp("test_directories", "example_substitutions", "ExperimentalData"),
                            rfp("test_directories", "example_substitutions",
                                "substitutions_parents.yml"))
    return crawler


def test_substitutions(crawler):
    # @review Florian Spreckelsen 2022-05-13
    for i in range(2):
        subd = crawler.debug_tree[dircheckstr(
            "File", "ExperimentalData", "220512_data.dat")]
        assert subd[i]["Experiment"].get_property("date").value == "2022-05-12"
        assert isinstance(subd[i]["ExperimentSeries"].get_property(
            "Experiment").value, db.Record)

        subd = crawler.debug_tree[dircheckstr("Directory", "ExperimentalData")]
        assert subd[i]["Project"].name == "project"
        assert isinstance(subd[i]["Project"].get_property(
            "Experiments").value, list)
        assert isinstance(subd[i]["Project"].get_property(
            "Experiments").value[0], db.Record)

        assert isinstance(subd[i]["Project"].get_property("dates").value, list)
        assert subd[i]["Project"].get_property(
            "dates").value[0] == "2022-05-12"


def test_substitutions_parents(crawler_2):
    # This is a test for:
    # https://gitlab.indiscale.com/caosdb/src/caosdb-crawler/-/issues/35
    # ... testing whether variable substitutions can be used in parent declarations.
    subd = crawler_2.debug_tree[dircheckstr(
        "File", "ExperimentalData", "220512_data.dat")]
    # subd[0] <- generalStore
    # subd[1] <- recordStore

    parents = subd[1]["Experiment"].get_parents()
    assert len(parents) == 2
    assert parents[0].name == "Experiment"
    assert parents[1].name == "Month_05"
