#!/bin/python
# Tests for schema validation
# A. Schlemmer, 06/2021

from importlib_resources import files
import caosdb as db

from os.path import join, dirname
from caoscrawler import Crawler

import pytest
from pytest import raises

from jsonschema.exceptions import ValidationError


def rfp(*pathcomponents):
    """
    Return full path.
    Shorthand convenience function.
    """
    return join(dirname(__file__), *pathcomponents)


def test_schema_validation():
    cr = Crawler()
    cr.load_definition(rfp("scifolder_cfood.yml"))
    cr.load_definition(rfp("scifolder_extended.yml"))

    with raises(ValidationError, match=".*enum.*"):
        cr.load_definition(rfp("broken_cfoods", "broken1.yml"))
