#!/bin/python
# Tests for:
# https://gitlab.com/caosdb/caosdb-crawler/-/issues/9
# A. Schlemmer, 06/2021

import pytest

# The main function that is affected by this issue:
from caoscrawler.converters import handle_value
from caoscrawler.crawl import Crawler
# We need the store for the above function
from caoscrawler.stores import GeneralStore

from test_tool import dircheckstr, rfp


@pytest.fixture
def crawler():
    crawler = Crawler(debug=True)
    crawler.crawl_directory(rfp("test_directories", "examples_article"),
                            rfp("cfoods_scalar.yml"))
    return crawler


def test_handle_value():
    # Note that we will need this store only, if we also want to test variables substitution:
    store = GeneralStore()

    # This one should work:
    assert handle_value("bla", store) == ("bla", "single")

    # These failed:
    assert handle_value(4, store) == (4, "single")
    assert handle_value(4.2, store) == (4.2, "single")
    assert handle_value(True, store) == (True, "single")

    # List test:
    assert handle_value([4, 3, 2], store) == ([4, 3, 2], "single")


def test_record_structure_generation(crawler):
    subd = crawler.debug_tree[dircheckstr("DataAnalysis")]
    assert len(subd) == 2
    # variables store on Data Analysis node of debug tree
    assert len(subd[0]) == 3
    assert "Data" in subd[0]
    assert "DataAnalysis" in subd[0]
    assert "RecordThatGetsParentsLater" in subd[0]

    prop = subd[0]["RecordThatGetsParentsLater"].get_property("someId")
    assert type(prop.value) == int
    assert prop.value == 23

    # record store on Data Analysis node of debug tree
    assert len(subd[1]) == 1
    prop2 = subd[1]["RecordThatGetsParentsLater"].get_property("someId")
    assert prop == prop2
