#!/usr/bin/env python3
# encoding: utf-8
#
# This file is a part of the CaosDB Project.
#
# Copyright (C) 2022 IndiScale GmbH <info@indiscale.com>
# Copyright (C) 2022 Florian Spreckelsen <f.spreckelsen@indiscale.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#

from pytest import mark

from caoscrawler.crawl import Crawler
from caoscrawler.structure_elements import Dict
from test_tool import rfp


@mark.xfail(
    reason="Wait until value conversion in dicts is fixed, see "
    "https://gitlab.com/caosdb/caosdb-crawler/-/issues/10."
)
def test_issue_10():
    """Test integer-to-float conversion in dictionaries"""
    crawler_definition = {
        "DictTest": {
            "type": "Dict",
            "match": "(.*)",
            "records": {
                "TestRec": {}
            },
            "subtree": {
                "float_element": {
                    "type": "DictFloatElement",
                    "match_name": "float_value",
                    "match_value": "(?P<float_value>.*)",
                    "records": {
                        "TestRec": {
                            "float_prop": "$float_value"
                        }
                    }
                }
            }
        }
    }

    crawler = Crawler(debug=True)
    converter_registry = crawler.load_converters(crawler_definition)

    test_dict = {
        "float_value": 4
    }

    records = crawler.start_crawling(
        Dict("TestDict", test_dict), crawler_definition, converter_registry)
    assert len(records) == 1
    assert records[0].parents[0].name == "TestRec"
    assert records[0].get_property("float_prop") is not None
    assert float(records[0].get_property("float_prop").value) == 4.0
