#!/bin/python
# Tests for entity comparison
# A. Schlemmer, 06/2021

import caosdb as db
from pytest import raises

from caoscrawler.identified_cache import _create_hashable_string as create_hash_string


def test_normal_hash_creation():
    # Test the initial functionality:
    # hash comprises only one parent, name and properties:

    r1 = db.Record()
    r1.add_property(name="test")
    r1.add_parent("bla")
    hash1 = create_hash_string(r1)

    r2 = db.Record()
    r2.add_property(name="test2")
    r2.add_parent("bla")
    hash2 = create_hash_string(r2)

    assert hash1 != hash2

    r3 = db.Record()
    r3.add_property(name="test")
    r3.add_parent("bla bla")
    hash3 = create_hash_string(r3)
    assert hash1 != hash3
    assert hash2 != hash3

    # no name and no properties and no parents:
    r4 = db.Record()
    with raises(RuntimeError, match=".*1 parent.*"):
        create_hash_string(r4)

    # should work
    r4.add_parent("bla")
    assert len(create_hash_string(r4)) > 0
    r4.add_property(name="test")
    assert len(create_hash_string(r4)) > 0

    r4.add_parent("bla bla")
    with raises(RuntimeError, match=".*1 parent.*"):
        create_hash_string(r4)


def test_file_hash_creation():
    f1 = db.File(path="/bla/bla/test1.txt")
    hash1 = create_hash_string(f1)
    f2 = db.File(path="/bla/bla/test2.txt")
    hash2 = create_hash_string(f2)

    assert hash1 != hash2
