/*
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2021 Daniel Hornung <d.hornung@indiscale.com>
 * Copyright (C) 2021 IndiScale GmbH <info@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */
#include "caosdb/configuration.h"      // for InsecureConnectionConfig...
#include "caosdb/connection.h"         // for Connection
#include "caosdb/result_set.h"         // for ResultSet
#include "caosdb/status_code.h"        // for StatusCode, EXECUTING
#include "caosdb/transaction.h"        // for Transaction
#include "caosdb/transaction_status.h" // for StatusCode
#include <gtest/gtest.h>
#include <gtest/gtest-message.h>   // for Message
#include <gtest/gtest-test-part.h> // for SuiteApiResolver, TestPa...
#include <gtest/gtest_pred_impl.h> // for Test, TestInfo, TEST
#include <memory>                  // for allocator, unique_ptr

namespace caosdb::transaction {
using caosdb::configuration::InsecureConnectionConfiguration;
using caosdb::connection::Connection;

TEST(test_issues, test_issue_11) {
  const auto *host = "localhost";
  auto configuration = InsecureConnectionConfiguration(host, 8000);
  Connection connection(configuration);
  auto transaction = connection.CreateTransaction();

  EXPECT_EQ(transaction->GetResultSet().size(), 0);
  transaction->RetrieveById("100");
  EXPECT_EQ(StatusCode::EXECUTING, transaction->ExecuteAsynchronously());
  // Trying to obtain ResultSet while it is still empty.
  EXPECT_EQ(transaction->GetResultSet().size(), 0);
  transaction->WaitForIt();
  EXPECT_EQ(transaction->GetResultSet().size(), 0);
}

} // namespace caosdb::transaction
