/*
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2021 Timm Fitschen <t.fitschen@indiscale.com>
 * Copyright (C) 2021 IndiScale GmbH <info@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 */

#ifndef CAOSDB_STATUS_CODE_H
#define CAOSDB_STATUS_CODE_H

#include <string>

/**
 * StatusCodes represent the status of this client, it's connections,
 * configuration and so on.
 *
 * In contrast to MessageCodes, these status codes do not represent the status
 * of the entities of a transaction or of the server (or only inasmuch the
 * GENERIC_TRANSACTION_ERROR indicates that *there are* errors in a
 * transaction).
 */

namespace caosdb {

enum StatusCode {
  READY = -4,
  GO_ON = -3,
  INITIAL = -2,
  EXECUTING = -1,
  SUCCESS = 0,
  AUTHENTICATION_ERROR = 16,
  CONNECTION_ERROR = 14,
  GENERIC_RPC_ERROR = 20,
  GENERIC_ERROR = 21,
  GENERIC_TRANSACTION_ERROR = 22,
  CONFIGURATION_ERROR = 23,
  UNKNOWN_CONNECTION_ERROR = 24,
  TRANSACTION_STATUS_ERROR = 25,
  TRANSACTION_TYPE_ERROR = 26,
  UNSUPPORTED_FEATURE = 27,
  ORIGINAL_ENTITY_MISSING_ID = 28,
};

auto get_status_description(int code) -> const std::string &;

} // namespace caosdb
#endif
