/*
 *
 * This file is a part of the CaosDB Project.
 *
 * Copyright (C) 2021 Timm Fitschen <t.fitschen@indiscale.com>
 * Copyright (C) 2021 IndiScale GmbH <info@indiscale.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 */

#ifndef CAOSDB_TEST_UTILITY_H
#define CAOSDB_TEST_UTILITY_H
/**
 * WARNING: THIS FILE IS MAINTAINED AS PART OF THE caosdb-cpplib. Please commit
 * changes there and keep these files in sync!
 *
 * @file caosdb_test_utility.h
 * @brief Utility for the unit tests
 * @author Timm Fitschen
 * @date 2021-07-07
 */
#define EXPECT_THROW_MESSAGE(statement, exeption_type, message)                                    \
  EXPECT_THROW(                                                                                    \
    try { statement; } catch (const exeption_type &e) {                                            \
      EXPECT_EQ(std::string(e.what()), message);                                                   \
      throw;                                                                                       \
    },                                                                                             \
    exeption_type)
#define ASSERT_THROW_MESSAGE(statement, exeption_type, message)                                    \
  ASSERT_THROW(                                                                                    \
    try { statement; } catch (const exeption_type &e) {                                            \
      ASSERT_EQ(std::string(e.what()), message);                                                   \
      throw;                                                                                       \
    },                                                                                             \
    exeption_type)
#define EXPECT_THROW_STARTS_WITH(statement, exception_type, pattern)                               \
  EXPECT_THROW(                                                                                    \
    try { statement; } catch (const exception_type &e) {                                           \
      auto pat_s = std::string(pattern);                                                           \
      EXPECT_EQ(std::string(e.what()).substr(0, pat_s.size()), pat_s);                             \
      throw;                                                                                       \
    },                                                                                             \
    exception_type)
#endif
